<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" Inherits="Voxco.Reporting.VariableSelection" Title="<%$ Resources:Resource, VoxcoReporting%>" Theme="Voxco" Codebehind="VariableSelection.aspx.cs" %>

<%@ Register Src="~/WaitingPanel.ascx" TagPrefix="VxRpt" TagName="WaitingPanel" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>


<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" Runat="Server">

	<telerik:RadScriptBlock ID="RadScriptBlock" runat="server">   
		<script type="text/javascript">

		    if (Telerik.Web.UI.RadTreeView != undefined) {
		        Telerik.Web.UI.RadTreeView.prototype.saveClientState = function () {
		            return "{\"expandedNodes\":" + this._expandedNodesJson +
		                ",\"collapsedNodes\":" + this._collapsedNodesJson +
		                ",\"logEntries\":" + this._logEntriesJson +
		                ",\"selectedNodes\":" + this._selectedNodesJson +
		                ",\"checkedNodes\":" + this._checkedNodesJson +
		                ",\"scrollPosition\":" + Math.round(this._scrollPosition) + "}";
		        }
		    }

		    function treeSelectedDropTest(source, dest, events) {
		        if (dest._destNode.get_value().substring(0, 3) == "OG:" && source.get_parent() != null && source.get_parent() != dest._destNode.get_value()) {
		            return true;
		        }
		        // allow moving all group's elements in another group
		        if (source.get_selectedNode().get_value().substring(0, 3) == "OG:" && dest.get_destNode().get_value().substring(0, 3) == "OG:") {
		            return true;
		        }
		        return false;
		    }

		    function ContextMenuClick(node, itemText) {
		        if (itemText == "Disable") {
		            node.Disable();
		            return false;
		        }
		        if (itemText == "Enable All") {
		            var _nodes = node.TreeView.get_allNodes();
		            for (var i = 0; i < _nodes.length; i++) {
		                _nodes[i].enable();
		            }
		        }
		        if (itemText == "Edit") {
		            node.StartEdit();
		        }

		        return true;
		    }

		    function UpdateAllChildren(nodes, checked) {
		        for (i = 0; i < nodes.length; i++) {
		            checked ? nodes[i].Check() : nodes[i].UnCheck();
		            if (nodes[i].Nodes.length > 0) {
		                UpdateAllChildren(nodes[i].Nodes, checked);
		            }
		        }
		    }

		    function OnCheckedNode(node) {
		        $find("<%= VariablesRadAjaxPanel.ClientID %>").ajaxRequest("SetSelectedNodes");
		    }

		    function ValidateSelection() {
		        var _count = 0;
		        var tree = $find("<%= treeSelectedBanners.ClientID %>");
		        var _nodes = tree.get_allNodes();
		        for (var i = 0; i < _nodes.length; i++) {
		            if (_nodes[i].checked)
		                _count++;

		            if (_count > 1) {
		                alert("<%= GetUninqueSelectionMessage() %>");
		                break;
		            }
		        }

		        return (_count == 1);
		    }

		    function InputKeyUp(_buttonId, evt) {
		        if (13 == evt.keyCode) {
		            __doPostBack(_buttonId, '')
		        }
		    }
		    function pagerSelectionResize() {
		        $('.rcbInputCell :input').css('width', '20px');
		    }
	        
		</script>
    </telerik:RadScriptBlock>
    
    
    <asp:ObjectDataSource ID="UnusedQuestionsDataSource" runat="server" SelectMethod="GetGenericUnused"
        TypeName="Voxco.Reporting.DataSource.QuestionsDS">
    </asp:ObjectDataSource>
    
    <asp:ObjectDataSource ID="RowsDataSource" runat="server" SelectMethod="GetRowsGeneric"
        TypeName="Voxco.Reporting.DataSource.QuestionsDS">
    </asp:ObjectDataSource>
    
    <asp:ObjectDataSource ID="BannersDataSource" runat="server" SelectMethod="GetBannersGeneric"
        TypeName="Voxco.Reporting.DataSource.QuestionsDS">
    </asp:ObjectDataSource>

    <telerik:RadAjaxPanel ID="VariablesRadAjaxPanel" runat="server" Height="450px" EnableAJAX="true" LoadingPanelID="MainAjaxLoadingPanel" OnAjaxRequest="MainAjaxManager_OnAjaxRequest" CssClass="mainContent">
        <br />
        <telerik:RadAjaxLoadingPanel ID="MainAjaxLoadingPanel" runat="server" Transparency="25" >
            <VxRpt:WaitingPanel id="WaitingPanel" runat="server" />
        </telerik:RadAjaxLoadingPanel>
            
        <asp:Panel ID="RadSplitter1" Width="100%" Height="100%" runat="server">
			
			<div id="RadPaneLeft" runat="server" style="float: left; width: 30%;">
				
				<div id="variableSelectionCol1">
					
					<asp:Label ID="Panel2" runat="server" Text="<%$ Resources:Resource, DiscreteVariables%>" CssClass="title"></asp:Label>
                    
					<div>
						<asp:TextBox ID="FindVariableTxt" runat="server"  Width="150px" ></asp:TextBox> 
						<asp:ImageButton ID="FindVariableBt" runat="server" ImageUrl="~/icons/ico16_find.gif" OnClick="FindVariable_Click" ToolTip="<%$ Resources:Resource, Find%>" />
						<asp:ImageButton ID="ClearVariableBt" runat="server" ImageUrl="~/icons/cancel.gif" OnClick="ResetVariable_Click" ToolTip="<%$ Resources:Resource, Clear%>" />
					</div>
	                    
					<div id="variableSelectionList">
						<telerik:RadGrid ID="grdQuestions" runat="server" AllowMultiRowSelection="True"  OnPageIndexChanged="grdQuestions_PageIndexChanged"
						AutoGenerateColumns="False" Height="420" EnableViewState="true" PageSize="50"  OnNeedDataSource="grdQuestions_OnNeedDataSource" AllowPaging="true"
						EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true" OnDataBound="grdQuestions_OnDataBound">
                            <MasterTableView NoMasterRecordsText="" Width="100%">
								<Columns>
									<telerik:GridClientSelectColumn UniqueName="Selected" >
										<HeaderStyle Width="15%" HorizontalAlign="Center" />
										<ItemStyle Width="15%" HorizontalAlign="center" />
									</telerik:GridClientSelectColumn>
									<telerik:GridBoundColumn DataField="Alias" HeaderText="<%$ Resources:Resource, Question%>" UniqueName="QuestionAlias">											
										<HeaderStyle Width="85%" HorizontalAlign="left" />
										<ItemStyle Width="85%" HorizontalAlign="left" />
									</telerik:GridBoundColumn>
									<telerik:GridBoundColumn DataField="ChoiceCount" UniqueName="ChoiceCount" Visible="true" Display="false">
									</telerik:GridBoundColumn>
								</Columns>
							</MasterTableView>
							<ClientSettings AllowGroupExpandCollapse="True">
								<Selecting UseClientSelectColumnOnly="True"  AllowRowSelect="True" />
								<Scrolling AllowScroll="True" UseStaticHeaders="True" />
							</ClientSettings>					
						</telerik:RadGrid>
					</div>
					
                </div>
                
			</div>
			
			<div id="RadPaneMiddle" runat="server" style="float: left; width: 25px;">				
                
				<div id="variableSelectionArrow1">    
					<asp:ImageButton ID="btnAddRows" runat="server" ImageUrl="~/icons/arrow_right_blue.png" ToolTip="<%$ Resources:Resource, AddSelectedItems %>" OnClick="btnAddRows_Click" />
					<asp:ImageButton ID="btnRemoveRows" runat="server" ImageUrl="~/icons/arrow_left_blue.png" ToolTip="<%$ Resources:Resource, RemoveSelectetedItem %>" OnClick="btnRemoveRows_Click" />   
               </div>
               <div id="variableSelectionArrow2">
					<asp:ImageButton ID="btnAddBanner" runat="server" ImageUrl="~/icons/arrow_right_blue.png" ToolTip="<%$ Resources:Resource, AddSelectedItems %>" OnClick="btnAddBannerToNewGroup_OnClick" />
					<asp:ImageButton ID="btnAddBannerVariable" runat="server" ImageUrl="~/icons/arrow_right_green.png" ToolTip="<%$ Resources:Resource, AddSelectedItemsToNewGroup %>" OnClick="btnAddBanner_OnClick" />
					<asp:ImageButton ID="btnRemoveBanner" runat="server" ImageUrl="~/icons/arrow_left_blue.png" ToolTip="<%$ Resources:Resource, RemoveSelectetedItem %>" OnClick="btnRemoveBanner_OnClick" />
				</div>
                            
			</div>
			
			<div id="RadPaneRight" runat="server" style="float: left; width: 30%; height: 100%;">
				
				<asp:Label ID="Panel1" runat="server" Text="<%$ Resources:Resource, Rows%>" CssClass="title"></asp:Label>
                   
				<telerik:RadGrid ID="grdRows" runat="server" Height="200px" AllowMultiRowSelection="True" DataSourceID="RowsDataSource" 
                EnableViewState="true" OnDataBound="grdRows_DataBound" AutoGenerateColumns="false"
                EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
					<MasterTableView GroupLoadMode="Client" DataSourceID="RowsDataSource" NoDetailRecordsText="" NoMasterRecordsText="" Width="100%">
						<Columns>
							<telerik:GridClientSelectColumn UniqueName="Selected">
								<HeaderStyle Width="15%" />
								<ItemStyle Width="15%" />
							</telerik:GridClientSelectColumn>
							<telerik:GridBoundColumn DataField="Alias" HeaderImageUrl="../icons/to-row.png" HeaderText="<%$ Resources:Resource, Question%>" UniqueName="QuestionAlias">
								<HeaderStyle Width="85%" HorizontalAlign="left" />
								<ItemStyle Width="85%" HorizontalAlign="left" />
							</telerik:GridBoundColumn>
							<telerik:GridBoundColumn DataField="Invalid" UniqueName="Invalid" Display="false">
							</telerik:GridBoundColumn>
						</Columns>
					</MasterTableView>
                    <ClientSettings AllowGroupExpandCollapse="True">
                        <Selecting UseClientSelectColumnOnly="True" AllowRowSelect="True" />
                        <Scrolling AllowScroll="True" UseStaticHeaders="True" />
                    </ClientSettings>
                </telerik:RadGrid>                        
                    
                <asp:Label ID="Panel4" runat="server" Text="<%$ Resources:Resource, Banners%>" CssClass="title" Width="100%"></asp:Label>
					
				<div id="variableSelectionBannersTree" style="float: left; width: 90%; height: 232px; overflow: auto; border: 1px solid #828282;">
					&nbsp;
					<telerik:radtreeview 
						id="treeSelectedBanners"
						AllowNodeEditing="False" 
						SingleExpandPath="False" 
						OnClientNodeDropping="treeSelectedDropTest"
						OnClientNodeChecked="OnCheckedNode"
						MultipleSelect="True" 
						CheckBoxes="True" 
						DataSourceID="BannersDataSource"
						DataValueField="NodeId"
						DataTextField="NodeLabel"
						DataFieldID="NodeId"
						DataFieldParentID="ParentNodeId"
						OnNodeDataBound="treeSelectedBanners_OnNodeBound"
						EnableDragAndDrop="False" 						
						Height="200px" 								
						Width="100%"
						runat="server">
					</telerik:radtreeview>
				</div>
				<div id="variableSelectionBannersArrow" style="float: left; height: 225px; width: 25px;">
					<div class="arrows">
						<asp:ImageButton ID="lnkMoveUp" runat="server" ImageUrl="~/icons/arrow_up_blue.png" ToolTip="<%$ Resources:Resource, MoveUp %>"  OnClick="lnkMoveUp_Click" />								
						<asp:ImageButton ID="lnkMoveDown" runat="server" ImageUrl="~/icons/arrow_down_blue.png" ToolTip="<%$ Resources:Resource, MoveDown %>" OnClick="lnkMoveDown_Click" />
					</div>
				</div>
				<div style="clear:both;"></div>                                    
			</div>
			
			<div style="float: left; width: 30%; margin-left: 10px;">
				<asp:Panel ID="RadPaneOptions" runat="server">                
					<div id="variableSelectionCol3">
						<asp:CheckBox ID="UseTendency" runat="server" Text="<%$ Resources:Resource, UseTendency%>" AutoPostBack="true" OnCheckedChanged="UseTendency_CheckedChanged" />							
						<asp:panel id="TendencyPanel" runat="server" GroupingText="<%$ Resources:Resource, Tendency%>">														
							<asp:Label ID="Label1" runat="server"  Visible="false" Text="<%$ Resources:Resource, Period%>" CssClass="paddingLabel"></asp:Label>      							
							<asp:Label ID="PeriodLabel" runat="server" Text="<%$ Resources:Resource, All%>" CssClass="paddingLabel"></asp:Label>							
							<br />
							<asp:Label ID="ByLabel" runat="server" Width="65px" Text="<%$ Resources:Resource, GroupedBy%>" CssClass="paddingLabel"></asp:Label>
							<telerik:RadTextBox ID="DurationTxt" runat="server"  Width="30px"  Font-Size="8pt" Text="1" AutoPostBack="true" OnTextChanged="DurationTxt_TextChanged" >
							</telerik:RadTextBox>
							<br />
							<asp:RadioButtonList ID="TendencyPerods" runat="server" RepeatDirection="Horizontal" AutoPostBack="true" OnSelectedIndexChanged="TendencyPerods_SelectedIndexChanged" >
							<asp:ListItem Selected="true" Value="Days" Text="<%$ Resources:Resource, Days%>"></asp:ListItem>
							<asp:ListItem Value="Months" Text="<%$ Resources:Resource, Months%>"></asp:ListItem>
							</asp:RadioButtonList>  							
						</asp:panel>
	                
						<asp:CheckBox ID="UsePageBreakDown" runat="server" Text="<%$ Resources:Resource, UsePageBreakDown%>" AutoPostBack="true" OnCheckedChanged="UsePageBreakDown_CheckedChanged" />
						<asp:Panel id="PageBreakDownPanel" runat="server" GroupingText="<%$ Resources:Resource, PageBreakDown%>">																					
							<asp:Label ID="BreakDownVarLabel" runat="server" Text="<%$ Resources:Resource, BreakDownVariable%>" CssClass="paddingLabel">
							</asp:Label> :
							<asp:DropDownList ID="BreakDownVariables" runat="server" Width="150px" DataSourceID="UnusedQuestionsDataSource" DataTextField="Alias" DataValueField="Alias"></asp:DropDownList>    
						</asp:Panel>
	                
						<asp:Panel id="variableSelectionData" runat="server" GroupingText="<%$ Resources:Resource, DataCalculationOptions %>">							
							<asp:RadioButtonList ID="DataCalculationOptions" runat="server" CellPadding="0" CellSpacing="5"  Font-Size="8pt" RepeatDirection="Horizontal">
								<asp:ListItem Selected="True" Value="Respondent" Text="<%$ Resources:Resource, RespondentBased %>"></asp:ListItem>
								<asp:ListItem Value="Response" Text="<%$ Resources:Resource, ResponseBased %>"></asp:ListItem>
							</asp:RadioButtonList>							
						</asp:Panel>                
					</div>
				</asp:Panel>
			</div>        
        </asp:Panel>

    </telerik:RadAjaxPanel>
    
</asp:Content>

